/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.datafix;

import com.google.common.collect.ImmutableMap;
import io.redspace.ironsspellbooks.datafix.DataFixerElement;
import io.redspace.ironsspellbooks.datafix.IronsWorldUpgrader;
import io.redspace.ironsspellbooks.datafix.fixers.FixApoth;
import io.redspace.ironsspellbooks.datafix.fixers.FixIsbEnhance;
import io.redspace.ironsspellbooks.datafix.fixers.FixIsbSpell;
import io.redspace.ironsspellbooks.datafix.fixers.FixIsbSpellbook;
import io.redspace.ironsspellbooks.datafix.fixers.FixItemNames;
import io.redspace.ironsspellbooks.datafix.fixers.FixSpellbookSlots;
import io.redspace.ironsspellbooks.datafix.fixers.FixTetra;
import io.redspace.ironsspellbooks.datafix.fixers.FixUpgradeType;
import io.redspace.ironsspellbooks.spells.blood.AcupunctureSpell;
import io.redspace.ironsspellbooks.spells.blood.BloodNeedlesSpell;
import io.redspace.ironsspellbooks.spells.blood.BloodSlashSpell;
import io.redspace.ironsspellbooks.spells.blood.BloodStepSpell;
import io.redspace.ironsspellbooks.spells.blood.DevourSpell;
import io.redspace.ironsspellbooks.spells.blood.HeartstopSpell;
import io.redspace.ironsspellbooks.spells.blood.RaiseDeadSpell;
import io.redspace.ironsspellbooks.spells.blood.RayOfSiphoningSpell;
import io.redspace.ironsspellbooks.spells.blood.WitherSkullSpell;
import io.redspace.ironsspellbooks.spells.eldritch.AbyssalShroudSpell;
import io.redspace.ironsspellbooks.spells.eldritch.SculkTentaclesSpell;
import io.redspace.ironsspellbooks.spells.ender.BlackHoleSpell;
import io.redspace.ironsspellbooks.spells.ender.CounterspellSpell;
import io.redspace.ironsspellbooks.spells.ender.DragonBreathSpell;
import io.redspace.ironsspellbooks.spells.ender.EvasionSpell;
import io.redspace.ironsspellbooks.spells.ender.MagicArrowSpell;
import io.redspace.ironsspellbooks.spells.ender.MagicMissileSpell;
import io.redspace.ironsspellbooks.spells.ender.StarfallSpell;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.evocation.ChainCreeperSpell;
import io.redspace.ironsspellbooks.spells.evocation.FangStrikeSpell;
import io.redspace.ironsspellbooks.spells.evocation.FangWardSpell;
import io.redspace.ironsspellbooks.spells.evocation.FirecrackerSpell;
import io.redspace.ironsspellbooks.spells.evocation.GustSpell;
import io.redspace.ironsspellbooks.spells.evocation.InvisibilitySpell;
import io.redspace.ironsspellbooks.spells.evocation.LobCreeperSpell;
import io.redspace.ironsspellbooks.spells.evocation.ShieldSpell;
import io.redspace.ironsspellbooks.spells.evocation.SpectralHammerSpell;
import io.redspace.ironsspellbooks.spells.evocation.SummonHorseSpell;
import io.redspace.ironsspellbooks.spells.evocation.SummonVexSpell;
import io.redspace.ironsspellbooks.spells.fire.BlazeStormSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import io.redspace.ironsspellbooks.spells.fire.FireBreathSpell;
import io.redspace.ironsspellbooks.spells.fire.FireballSpell;
import io.redspace.ironsspellbooks.spells.fire.FireboltSpell;
import io.redspace.ironsspellbooks.spells.fire.MagmaBombSpell;
import io.redspace.ironsspellbooks.spells.fire.WallOfFireSpell;
import io.redspace.ironsspellbooks.spells.holy.AngelWingsSpell;
import io.redspace.ironsspellbooks.spells.holy.BlessingOfLifeSpell;
import io.redspace.ironsspellbooks.spells.holy.CloudOfRegenerationSpell;
import io.redspace.ironsspellbooks.spells.holy.FortifySpell;
import io.redspace.ironsspellbooks.spells.holy.GreaterHealSpell;
import io.redspace.ironsspellbooks.spells.holy.GuidingBoltSpell;
import io.redspace.ironsspellbooks.spells.holy.HealSpell;
import io.redspace.ironsspellbooks.spells.holy.HealingCircleSpell;
import io.redspace.ironsspellbooks.spells.holy.SunbeamSpell;
import io.redspace.ironsspellbooks.spells.holy.WispSpell;
import io.redspace.ironsspellbooks.spells.ice.ConeOfColdSpell;
import io.redspace.ironsspellbooks.spells.ice.FrostStepSpell;
import io.redspace.ironsspellbooks.spells.ice.FrostbiteSpell;
import io.redspace.ironsspellbooks.spells.ice.IceBlockSpell;
import io.redspace.ironsspellbooks.spells.ice.IcicleSpell;
import io.redspace.ironsspellbooks.spells.ice.SummonPolarBearSpell;
import io.redspace.ironsspellbooks.spells.lightning.AscensionSpell;
import io.redspace.ironsspellbooks.spells.lightning.ChainLightningSpell;
import io.redspace.ironsspellbooks.spells.lightning.ChargeSpell;
import io.redspace.ironsspellbooks.spells.lightning.ElectrocuteSpell;
import io.redspace.ironsspellbooks.spells.lightning.LightningBoltSpell;
import io.redspace.ironsspellbooks.spells.lightning.LightningLanceSpell;
import io.redspace.ironsspellbooks.spells.nature.AcidOrbSpell;
import io.redspace.ironsspellbooks.spells.nature.BlightSpell;
import io.redspace.ironsspellbooks.spells.nature.PoisonArrowSpell;
import io.redspace.ironsspellbooks.spells.nature.PoisonBreathSpell;
import io.redspace.ironsspellbooks.spells.nature.PoisonSplashSpell;
import io.redspace.ironsspellbooks.spells.nature.RootSpell;
import io.redspace.ironsspellbooks.spells.nature.SpiderAspectSpell;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;

public class DataFixerHelpers {
    public static final Map<Integer, String> LEGACY_SPELL_MAPPING = ImmutableMap.builder().put((Object)1, (Object)new FireballSpell().getSpellId()).put((Object)2, (Object)new BurningDashSpell().getSpellId()).put((Object)3, (Object)new TeleportSpell().getSpellId()).put((Object)4, (Object)new MagicMissileSpell().getSpellId()).put((Object)5, (Object)new ElectrocuteSpell().getSpellId()).put((Object)6, (Object)new ConeOfColdSpell().getSpellId()).put((Object)7, (Object)new HealSpell().getSpellId()).put((Object)8, (Object)new BloodSlashSpell().getSpellId()).put((Object)9, (Object)new SummonVexSpell().getSpellId()).put((Object)10, (Object)new FireboltSpell().getSpellId()).put((Object)11, (Object)new FireBreathSpell().getSpellId()).put((Object)12, (Object)new IcicleSpell().getSpellId()).put((Object)13, (Object)new FirecrackerSpell().getSpellId()).put((Object)14, (Object)new SummonHorseSpell().getSpellId()).put((Object)15, (Object)new AngelWingsSpell().getSpellId()).put((Object)16, (Object)new ShieldSpell().getSpellId()).put((Object)17, (Object)new WallOfFireSpell().getSpellId()).put((Object)18, (Object)new WispSpell().getSpellId()).put((Object)19, (Object)new FangStrikeSpell().getSpellId()).put((Object)20, (Object)new FangWardSpell().getSpellId()).put((Object)21, (Object)new EvasionSpell().getSpellId()).put((Object)22, (Object)new HeartstopSpell().getSpellId()).put((Object)23, (Object)new LightningLanceSpell().getSpellId()).put((Object)24, (Object)new LightningBoltSpell().getSpellId()).put((Object)25, (Object)new RaiseDeadSpell().getSpellId()).put((Object)26, (Object)new WitherSkullSpell().getSpellId()).put((Object)27, (Object)new GreaterHealSpell().getSpellId()).put((Object)28, (Object)new CloudOfRegenerationSpell().getSpellId()).put((Object)29, (Object)new RayOfSiphoningSpell().getSpellId()).put((Object)30, (Object)new MagicArrowSpell().getSpellId()).put((Object)31, (Object)new LobCreeperSpell().getSpellId()).put((Object)32, (Object)new ChainCreeperSpell().getSpellId()).put((Object)33, (Object)new BlazeStormSpell().getSpellId()).put((Object)34, (Object)new FrostStepSpell().getSpellId()).put((Object)35, (Object)new AbyssalShroudSpell().getSpellId()).put((Object)36, (Object)new FrostbiteSpell().getSpellId()).put((Object)37, (Object)new AscensionSpell().getSpellId()).put((Object)38, (Object)new InvisibilitySpell().getSpellId()).put((Object)39, (Object)new BloodStepSpell().getSpellId()).put((Object)40, (Object)new SummonPolarBearSpell().getSpellId()).put((Object)41, (Object)new BlessingOfLifeSpell().getSpellId()).put((Object)42, (Object)new DragonBreathSpell().getSpellId()).put((Object)43, (Object)new FortifySpell().getSpellId()).put((Object)44, (Object)new CounterspellSpell().getSpellId()).put((Object)45, (Object)new SpectralHammerSpell().getSpellId()).put((Object)46, (Object)new ChargeSpell().getSpellId()).put((Object)47, (Object)new SculkTentaclesSpell().getSpellId()).put((Object)48, (Object)new IceBlockSpell().getSpellId()).put((Object)49, (Object)new PoisonBreathSpell().getSpellId()).put((Object)50, (Object)new PoisonArrowSpell().getSpellId()).put((Object)51, (Object)new PoisonSplashSpell().getSpellId()).put((Object)52, (Object)new AcidOrbSpell().getSpellId()).put((Object)53, (Object)new SpiderAspectSpell().getSpellId()).put((Object)54, (Object)new BlightSpell().getSpellId()).put((Object)55, (Object)new RootSpell().getSpellId()).put((Object)56, (Object)new BlackHoleSpell().getSpellId()).put((Object)57, (Object)new BloodNeedlesSpell().getSpellId()).put((Object)58, (Object)new AcupunctureSpell().getSpellId()).put((Object)59, (Object)new MagmaBombSpell().getSpellId()).put((Object)60, (Object)new StarfallSpell().getSpellId()).put((Object)61, (Object)new HealingCircleSpell().getSpellId()).put((Object)62, (Object)new GuidingBoltSpell().getSpellId()).put((Object)63, (Object)new SunbeamSpell().getSpellId()).put((Object)64, (Object)new GustSpell().getSpellId()).put((Object)65, (Object)new ChainLightningSpell().getSpellId()).put((Object)66, (Object)new DevourSpell().getSpellId()).build();
    public static final Map<String, String> LEGACY_ITEM_IDS = ImmutableMap.builder().put((Object)"irons_spellbooks:poison_rune", (Object)"irons_spellbooks:nature_rune").put((Object)"irons_spellbooks:poison_upgrade_orb", (Object)"irons_spellbooks:nature_upgrade_orb").build();
    public static final Map<String, String> LEGACY_UPGRADE_TYPE_IDS = ImmutableMap.builder().put((Object)"fire_power", (Object)"irons_spellbooks:fire_power").put((Object)"ice_power", (Object)"irons_spellbooks:ice_power").put((Object)"lightning_power", (Object)"irons_spellbooks:lightning_power").put((Object)"holy_power", (Object)"irons_spellbooks:holy_power").put((Object)"ender_power", (Object)"irons_spellbooks:ender_power").put((Object)"blood_power", (Object)"irons_spellbooks:blood_power").put((Object)"evocation_power", (Object)"irons_spellbooks:evocation_power").put((Object)"poison_power", (Object)"irons_spellbooks:nature_power").put((Object)"cooldown", (Object)"irons_spellbooks:cooldown").put((Object)"spell_resistance", (Object)"irons_spellbooks:spell_resistance").put((Object)"mana", (Object)"irons_spellbooks:mana").put((Object)"melee_damage", (Object)"irons_spellbooks:melee_damage").put((Object)"melee_speed", (Object)"irons_spellbooks:melee_speed").put((Object)"health", (Object)"irons_spellbooks:health").build();
    public static final Map<String, String> NEW_SPELL_IDS = ImmutableMap.builder().put((Object)"irons_spellbooks:void_tentacles", (Object)"irons_spellbooks:sculk_tentacles").build();
    public static List<DataFixerElement> DATA_FIXER_ELEMENTS = List.of(new FixSpellbookSlots(), new FixIsbEnhance(), new FixTetra(), new FixApoth(), new FixIsbSpellbook(), new FixIsbSpell(), new FixItemNames(), new FixUpgradeType());
    public static List<byte[]> DATA_MATCHER_TARGETS = ((Supplier<List>)() -> {
        List bytesList = DATA_FIXER_ELEMENTS.stream().flatMap(item -> item.preScanValueBytes().stream()).collect(Collectors.toList());
        bytesList.add(IronsWorldUpgrader.INHABITED_TIME_MARKER);
        return (ArrayList)bytesList;
    }).get();

    public static boolean doFixUps(CompoundTag tag) {
        AtomicInteger runningCount = new AtomicInteger();
        DATA_FIXER_ELEMENTS.forEach(fixerElement -> {
            if (fixerElement.runFixer(tag)) {
                runningCount.incrementAndGet();
            }
        });
        return runningCount.get() > 0;
    }
}

